/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.List;
import com.sun.lwuit.html.MultiCellRenderer;
import com.sun.lwuit.html.MultiListModel;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.list.ListModel;
import java.util.Vector;

class MultiComboBox
extends List {
    private boolean multiple;
    private MultiListModel model;

    MultiComboBox(boolean multiple) {
        this(null, multiple);
    }

    MultiComboBox(ListModel underlyingModel, boolean multiple) {
        Component c;
        ListCellRenderer r;
        this.setUIID("ComboBox");
        this.multiple = multiple;
        this.setScrollToSelected(!multiple);
        this.model = new MultiListModel(underlyingModel, multiple);
        this.setModel(this.model);
        MultiCellRenderer multiRenderer = new MultiCellRenderer(this.model);
        this.setListCellRenderer(multiRenderer);
        if (underlyingModel != null) {
            for (int i = 0; i < underlyingModel.getSize(); ++i) {
                if (!(underlyingModel.getItemAt(i) instanceof String)) continue;
                multiRenderer.setOptgroup(true);
                break;
            }
        }
        if ((r = this.getRenderer()) instanceof Component) {
            c = (Component)((Object)this.getRenderer());
            c.setUIID("ComboBoxItem");
            c.getSelectedStyle().setPadding(1, 1, 1, 1);
            c.getUnselectedStyle().setPadding(1, 1, 1, 1);
        }
        if ((c = this.getRenderer().getListFocusComponent(this)) != null) {
            c.setUIID("ComboBoxFocus");
        }
    }

    Vector getSelected() {
        if (this.model != null) {
            return this.model.selected;
        }
        return null;
    }

    public void addItem(Object item) {
        super.addItem(item);
        if (item instanceof String) {
            ((MultiCellRenderer)this.getRenderer()).setOptgroup(true);
        }
    }

    public void setSelectedItem(Object item) {
        super.setSelectedItem(item);
        this.model.toggleSelected(item);
    }

    protected void fireActionEvent() {
        if (this.multiple) {
            Object obj = this.getSelectedItem();
            this.model.toggleSelected(obj);
        } else {
            super.fireActionEvent();
        }
    }

    public void keyReleased(int keyCode) {
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (this.multiple && gameAction == 8) {
            boolean h = this.handlesInput();
            if (h) {
                this.fireActionEvent();
            }
            this.repaint();
            return;
        }
        super.keyReleased(keyCode);
    }

    protected void fireClicked() {
        boolean h = this.handlesInput();
        if (!this.multiple) {
            this.setHandlesInput(!h);
        }
        if (h) {
            this.fireActionEvent();
        }
        this.repaint();
    }

    public void keyPressed(int keyCode) {
        int keyBck;
        int keyFwd;
        if (!this.handlesInput()) {
            return;
        }
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (this.getOrientation() != 1) {
            keyFwd = 6;
            keyBck = 1;
            if (gameAction == 2 || gameAction == 5) {
                this.setHandlesInput(false);
            }
        } else {
            if (this.isRTL()) {
                keyFwd = 2;
                keyBck = 5;
            } else {
                keyFwd = 5;
                keyBck = 2;
            }
            if (gameAction == 6 || gameAction == 1) {
                this.setHandlesInput(false);
            }
        }
        int selectedIndex = this.model.getSelectedIndex();
        if (gameAction == keyBck) {
            if (selectedIndex > 0 && this.model.getItemAt(selectedIndex - 1) instanceof String) {
                if (selectedIndex == 1) {
                    return;
                }
                this.model.setDirection(-1);
                this.model.setSelectedIndex(--selectedIndex);
            }
        } else if (gameAction == keyFwd && selectedIndex < this.size() - 1 && this.model.getItemAt(selectedIndex + 1) instanceof String) {
            if (selectedIndex == this.size() - 2) {
                return;
            }
            this.model.setDirection(1);
            this.model.setSelectedIndex(++selectedIndex);
        }
        super.keyPressed(keyCode);
        this.model.setDirection(0);
    }
}

