#include  "syscalls.h"

/* _flushbuf: alokuje lub zapisuje i oprnia bufor danych wyjciowych */
int _flushbuf(int x, FILE *fp)
{
    unsigned nc;                     /* liczba znakw do zapisania */
    int bufsize;                     /* rozmiar bufora */
    
    if (fp < _iob || fp >= _iob + OPEN_MAX)
        return EOF;                  /* bd: niewaciwy wskanik */
    if ((fp->flag & (_WRITE|_ERR)) != _WRITE)
        return EOF;
    bufsize = (fp->flag & _UNBUF) ? 1 : BUFSIZ;
    if (fp->base == NULL)            /* nie ma jeszcze bufora */
        if ((fp->base = (char *) malloc(bufsize)) == NULL) {
            fp->flag |= _ERR;
            return EOF;              /* nie mona utworzy bufora */
    } else {                         /* bufor istnieje */
        nc = fp->ptr  fp->base;
        if (write(fp->fd, fp->base, nc) != nc) {
            fp->flag |= _ERR;
            return EOF;              /* bd: zwraca EOF */
        }
    }
    fp->ptr = fp->base;              /* pocztek bufora */
    *fp->ptr++ = (char) x;           /* zapisz biecy znak */
    fp->cnt = bufsize  1;

    return x;
}

/* fclose: zamyka plik */
int fclose(FILE *fp)
{
    int rc;                            /* kod wyjciowy */

    if ((rc = fflush(fp)) != EOF) {    /* czy s dane do zapisania? */
        free(fp->base);                /* zwolnij zaalokowany bufor */
        fp->ptr = NULL;
        fp->cnt = 0;
        fp->base = NULL;
        fp->flag &= ~(_READ | _WRITE);
    }
    return rc;
}

/* fflush: zapisuje i oprnia bufor pliku fp */
int fflush(FILE *fp)
{
    int rc = 0;

    if (fp < _iob || fp >= _iob + OPEN_MAX)
        return EOF;                        /* bd: niewaciwy wskanik */
    if (fp->flag & _WRITE)
        rc = _flushbuf(0, fp);
    fp->ptr = fp->base;
    fp->cnt = (fp->flag & _UNBUF) ? 1 : BUFSIZ;
    return rc;
}
