#include  <stdio.h>
#include  <stdlib.h>

#define   MAXBOT    3     /* dopuszczalna liczba wierszy u dou strony */
#define   MAXHDR    5     /* dopuszczalna liczba wierszy u gry strony */
#define   MAXLINE   100   /* dopuszczalna dugo pojedynczego wiersza */
#define   MAXPAGE   66    /* dopuszczalna liczba wierszy na stronie */

/* print: wypisywanie plikw  kady kolejny od nowej strony */
main(int argc, char *argv[])
{
    FILE *fp;
    void fileprint(FILE *fp, char *fname);

    if (argc == 1)        /* brak argumentw; wypisuj standardowe wejcie */
        fileprint(stdin, " ");
    else                  /* wypisuj plik(i) */
        while (--argc > 0)
            if ((fp = fopen(*++argv, "r")) == NULL) {
                fprint(stderr,"print: can't open %s\n",*argv);
                exit(1);
            } else {
                fileprint(fp, *argv);
                fclose(fp);
            }
    return 0;
}

/* fileprint: wypisuje plik fname */
void fileprint(FILE *fp, char *fname)
{
    lineno, pageno = 1;
    char line[MAXLINE];
    int heading(char *fname, int pageno);

    lineno = heading(fname, pageno++);
    while (fgets(line, MAXLINE, fp) != NULL) {
        if (lineno == 1) {
            fprintf(stdout, "\f");
            lineno = heading(fname, pageno++);
        }
        fputs(line, stdout);
        if (++lineno > MAXPAGE  MAXBOT)
            lineno = 1;
    }
    fprintf(stdout, "\f");    /* wysuw strony po zakoczeniu pliku */
}

/* heading: wypisuje nagwek i odpowiedni liczb pustych wierszy */
int heading(char *fname, int pageno)
{
    int ln = 3;

    fprintf(stdout, "\n\n");
    fprintf(stdout, "%s   page %d\n", fname, pageno);
    while (ln++ < MAXHDR)
        fprintf(stdout, "\n");
    return ln;
}
