#include  <stdio.h>
#include  <ctype.h>

#define   MAXLINE  100     /* dopuszczalna liczba znakw w wierszu */
#define   OCTLEN     6     /* dugo wartoci semkowej */

/* wypisywanie dowolnych danych wejciowych w czytelnej postaci */
main()
{
    int c, pos;
    int inc(int pos, int n);

    pos = 0;                  /* pozycja w wierszu */
    while ((c = getchar()) != EOF)
        if (iscntrl(c) || c == ' ') {  /* niedrukowalny lub spacja */
            pos = inc(pos, OCTLEN);
            printf(" \\%03o ", c);
            if (c == '\n') {           /* znak nowego wiersza? */
                pos = 0;
                putchar('\n');
            }
        } else {                       /* znak drukowalny */
            pos = inc(pos, 1);
            putchar(c);
        }
    return 0;
}

/* inc: zwiksza warto licznika pozycji dla danych wyjciowych */
int inc(int pos, int n)
{
    if (pos + n < MAXLINE)
        return pos+n;
    else {
        putchar('\n');
        return n;
    }
}
