#include  <stdio.h>
#include  <string.h>
#include  <ctype.h>
#include  <stdlib.h>

#define   MAXWORD  100

struct linklist {             /* lista numerw wierszy */
    int lnum;
    struct linklist *ptr;
}

struct tnode {                /* wze drzewa: */
    char *word;               /* wskazuje tekst */
    struct linklist *lines;   /* numery wierszy */
    struct tnode *left;       /* lewy wze podrzdny */
    struct tnode *right;      /* prawy wze podrzdny */
};

struct tnode *addtreex(struct tnode *, char *, int);
int getword(char *, int);
int noiseword(char *);
void treexprint(struct tnode *);

/* indeksator */
main()
{
    struct tnode *root;
    char word[MAXWORD];
    int linenum;   

    root = NULL;
    while (getword(word, MAXWORD) != EOF) {
        if (isalpha(word[0]) && noiseword(word) == -1)
            root = addtreex(root, word, linenum);
        else if (word[0] == '\n')
            linenum++;
    treexprint(root);
    return 0;
}

struct tnode *talloc(void);
struct linklist *lalloc(void);
void addln(struct tnode *, int);

/* addtreex: dodaje wze ze sowem w do wza p lub pod nim */
struct tnode *addtreex(struct tnode *p, char *w, int linenum)
{
    int cond;
    
    if (p == NULL) {     /* nowe sowo */
        p = talloc();    /* utwrz nowy wze */
        p->word = strdup(w);
        p->lines = lalloc();
        p->lines->lnum = linenum;
        p->lines->ptr = NULL;
        p->left = p->right = NULL;
    } else if ((cond = strcmp(w, p->word)) == 0)
        addln(p, linenum);
    else if (cond < 0)
        p->left = addtreex(p->left, w, linenum);
    else
        p->right = addtreex(p->right, w, linenum);
    return p;
}

/* addln: dodaje numer wiersza do listy */
void addln(struct tnode *p, int linenum)
{
    struct linklist *temp;

    temp = p->lines;
    while (temp->ptr != NULL && temp->lnum != linenum)
        temp = temp->ptr;
    if (temp->lnum != linenum) {
        temp->ptr = lalloc();
        temp->ptr->lnum = linenum;
        temp->ptr->ptr = NULL;
    }
}

/* treexprint: wypisuje zawarto drzewa p w kolejnoci alfabetycznej */
void treexprint(struct tnode *p)
{
    struct linklist *temp;

    if (p != NULL) {
        treexprint(p->left);
        printf("%10s: ", p->word);
        for (temp = p->lines; temp != NULL; temp = temp->ptr)
            printf("%4d ", temp->lnum);
        printf("\n");
        treexprint(p->right);
    }
}

/* lalloc: tworzy wze listy */
struct linklist *lalloc(void)
{
    return (struct linklist *) malloc(sizeof(struct linklist));
}

/* noiseword: identyfikuje sowo jako nieistotne */
int noiseword(char *w)
{
    static char *nw[] = {
        "a",
        "an",
        "and",
        "are",
        "in",
        "is",
        "of",
        "or",
        "that",
        "the",
        "this",
        "to"
    };
    int cond, mid;
    int low = 0;
    int high = sizeof(nw) / sizeof(char *)  1;

    while (low <= high) {
        mid = (low + high) / 2;
        if ((cond = strcmp(w, nw[mid])) < 0)
            high = mid  1;
        else if (cond > 0)
            low = mid + 1;
        else
            return mid;
    }
    return -1;
}

/* getword: pobiera nastpne sowo lub znak z wejcia */
int getword(char *word, int lim)
{
    int c, getch(void);
    void ungetch(int);
    char *w = word;
    
    while (isspace(c = getch()) && c != '\n')
        ;
    if (c != EOF)
        *w++ = c;
    if (!isalpha(c)) {
        *w = '\0';
        return c;
    }
    for ( ; --lim > 0; w++)
        if (!isalnum(*w = getch())) {
            ungetch(*w);
            break;
    }
    *w = '\0';
    return word[0];
}
