#include  <stdio.h>
#include  <ctype.h>
#include  <string.h>
#include  <stdlib.h>

struct tnode {              /* wze drzewa: */
    char *word;             /* wskazuje tekst */
    int match;              /* znaleziono dopasowanie */
    struct tnode *left;     /* lewy wze podrzdny */
    struct tnode *right;    /* prawy wze podrzdny */
};

#define   MAXWORD  100
#define   YES      1
#define   NO       0

struct tnode *addtreex(struct tnode *, char *, int, int *);
void treexprint(struct tnode *);
int getword(char *, int);

/* wypisywanie w kolejnoci alfabetycznej grup nazw zmiennych */
/* o identycznych pierwszych num znakach (domylnie 6) */
main(int argc, char *argv[])
{
    struct tnode *root;
    char word[MAXWORD];
    int found = NO;         /* YES, jeeli znaleziono dopasowanie */
    int num;                /* liczba pocztkowych znakw */

    num = (--argc && (*++argv)[0] == '-') ? atoi(argv[0]+1) : 6;
    root = NULL;
    while (getword(word, MAXWORD) != EOF) {
        if (isalpha(word[0]) && strlen(word) >= num)
            root = addtreex(root, word, num, &found);
        found = NO;
    }
    treexprint(root);
    return 0;
}

struct tnode *talloc(void);
int compare(char *, struct tnode *, int, int *);

/* addtreex: dodaje wze ze sowem w do wza p lub pod nim */
struct tnode *addtreex(struct tnode *p, char *w, 
                          int num, int *found)
{
    int cond;
    
    if (p == NULL) {     /* nowe sowo */
        p = talloc();    /* utwrz nowy wze */
        p->word = strdup(w);
        p->match = *found;
        p->left = p->right = NULL;
    } else if ((cond = compare(w, p, num, found)) < 0)
        p->left = addtreex(p->left, w, num, found);
    else if (cond > 0)
        p->right = addtreex(p->right, w, num, found);
    return p;
}

/* compare: porwnuje sowa i aktualizuje p->match */
int compare(char *s, struct tnode *p, int num, int *found)
{
    int i;
    char *t = p->word;

    for (i = 0; *s == *t; i++, s++, t++)
        if (*s == '\0')
            return 0;
    if (i >= num) {      /* pierwsze num znakw identyczne? */
        *found = YES;
        p->match = YES;
    }
    return *s - *t;
}

/* treexprint: wypisuje zawarto drzewa p w kolejnoci alfabetycznej, jeeli p->match == YES */
void treexprint(struct tnode *p)
{
    if (p != NULL) {
        treexprint(p->left);
        if (p->match)
            printf("%s\n", p->word);
        treexprint(p->right);
    }
}
