#include  <stdio.h>
#include  <string.h>
#include  <ctype.h>

enum { NAME, PARENS, BRACKETS };
enum { NO, YES };

void dcl(void);
void dirdcl(void);
void errmsg(char *);
int gettoken(void);

extern int tokentype;            /* typ ostatniego leksemu */
extern char token[];             /* ostatni cig leksemu */
extern char name[];              /* nazwa identyfikatora */
extern char datatype[];          /* typ danych  char, int itp. */
extern char out[];
extern int prevtoken;

/* dcl: analizuje skadni deklaratora */
void dcl(void)
{
    int ns;
    
    for (ns = 0; gettoken() == '*'; )   /* zliczanie znakw '*' */
        ns++;
    dirdcl();
    while (ns-- > 0)
        strcat(out, " pointer to");
}

/* dirdcl: analizuje skadni deklaratora bezporedniego */
void dirdcl(void)
{
    int type;
    void parmdcl(void);

    if (tokentype == '(') {             /* ( dcl ) */
        dcl();
        if (tokentype != ')')
            errmsg("error: missing )\n");
    } else if (tokentype == NAME) {     /* nazwa zmiennej */
        if (name[0] == \0)
            strcpy(name, token);
    } else
        prevtoken = YES;
    while ((type = gettoken()) == PARENS || type == BRACKETS || type == '(')
        if (type == PARENS)
            strcat(out, "function returning");
        else if (type== '(') {
            strcat(out, " function expecting");
            parmdcl();
            strcat(out, " and returning");
        } else {
            strcat(out, " array");
            strcat(out, token);
            strcat(out, " of");
        }
}

/* errmsg: wywietla komunikat bdu i sygnalizuje dostpny leksem */
void errmsg(char *msg)
{
    printf("%s", msg);
    prevtoken = YES;
}
