#include  <stdio.h>
#include  <string.h>
#include  <ctype.h>

enum { NAME, PARENS, BRACKETS };
enum { NO, YES };

void dcl(void);
void dirdcl(void);
void errmsg(char *);
int gettoken(void);

extern int tokentype;            /* typ ostatniego leksemu */
extern char token[MAXTOKEN];     /* ostatni cig leksemu */
extern char name[MAXTOKEN];      /* nazwa identyfikatora */
extern char out[1000];
extern int prevtoken;

/* dcl: analizuje skadni deklaratora */
void dcl(void)
{
    int ns;
    
    for (ns = 0; gettoken() == '*'; )   /* zliczanie znakw '*' */
        ns++;
    dirdcl();
    while (ns-- > 0)
        strcat(out, " pointer to");
}

/* dirdcl: analizuje skadni deklaratora bezporedniego */
void dirdcl(void)
{
    int type;

    if (tokentype == '(') {             /* ( dcl ) */
        dcl();
        if (tokentype != ')')
            errmsg("error: missing )\n");
    } else if (tokentype == NAME)       /* nazwa zmiennej */
        strcpy(name, token);
    else
        errmsg("error: expected name or (dcl)\n");
    while ((type = gettoken()) == PARENS || type == BRACKETS)
        if (type == PARENS)
            strcat(out, " function returning");
        else {
            strcat(out, " array");
            strcat(out, token);
            strcat(out, " of");
        }
}

/* errmsg: wywietla komunikat bdu i sygnalizuje dostpny leksem */
void errmsg(char *msg)
{
    printf("%s", msg);
    prevtoken = YES;
}
