#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>

#define   DEFLINES  10     /* standardowa liczba wypisywanych wierszy */
#define   LINES     100    /* najwiksza dopuszczalna liczba wypisywanych wierszy */
#define   MAXLEN    100    /* dopuszczalna dugo wiersza */

void error(char *);
int getline(char *, int);

/* wypisywanie ostatnich n wierszy danych wejciowych */
main(int argc, char *argv[])
{
    char *p;
    char *buf;               /* wskanik do duego bufora */
    char *bufend;            /* koniec bufora */
    char line[MAXLEN];       /* biecy wiersz wejciowy */
    char *lineptr[LINES];    /* wskaniki do odczytanych wierszy */
    int first, i, last, len, n, nlines;

    if (argc == 1)             /* brak argumentw */
        n = DEFLINES;          /* uywaj standardowej liczby wierszy */
    else if (argc == 2 && (*++argv)[0] == '-')
        n = atoi(argv[0]+1);
    else
        error("usage:  tail [-n]");
    if (n < 1 || n > LINES)    /* wartoci n poza zakresem ? */
        n = LINES;
    for (i = 0; i < LINES; i++)
        lineptr[i] = NULL;
    if ((p = buf = malloc(LINES * MAXLEN)) == NULL)
        error("tail: cannot allocate buf");
    bufend = buf + LINES * MAXLEN;
    last = 0;                  /* indeks ostatniego odczytanego wiersza */
    nlines = 0;                /* liczba odczytanych wierszy */
    while ((len = getline(line, MAXLEN)) > 0) {
        if (p + len + 1 >= bufend)
            p = buf;           /* zawinicie bufora */
        lineptr[last] = p;
        strcpy(lineptr[last], line);
        if (++last >= LINES)
            last = 0;          /* zawinicie wskanikw do bufora */
        p += len + 1;
        nlines++;
    }
    if (n > nlines)            /* zbyt mao wierszy wejciowych? */
        n = nlines;
    first = last  n;
    if (first < 0)             /* nastpio zawinicie */
        first += LINES;
    for (i = first; n-- > 0; i = (i + 1) % LINES)
        printf("%s", lineptr[i]);
    return 0;
}

/* error: wywietla komunikat bdu i koczy program */
void error(char *s)
{
    printf("%s\n", s);
    exit(1);
}
