#include  <stdio.h>

#define   MAXLINE  100     /* dopuszczalna dugo wiersza */
#define   TABINC   8       /* szeroko tabulatora */
#define   YES      1
#define   NO       0

void settab(int argc, char *argv[], char *tab);
void detab(char *tab);
int tabpos(int pos, char *tab);

/* zastpowanie tabulatorw spacjami */
main(int argc, char *argv[])
{
    char tab[MAXLINE+1];

    settab(argc, argv, tab);    /* inicjalizacja pozycji tabulacji */
    detab(tab);                 /* zastpowanie tabulatorw spacjami */
    return 0;
}

/* detab: zastpuje tabulatory spacjami */
void detab(char *tab)
{
    int c, pos = 1;

    while ((c = getchar()) != EOF) {
        if (c == '\t') {            /* tabulator */
            do
                putchar(' ');
            while (tabpos(pos++, tab) != YES);
        } else if (c == '\n') {     /* znak nowego wiersza */
            putchar(c);
            pos = 1;
        } else {                    /* wszystkie inne znaki */
            putchar(c);
            ++pos;
        }
}
