#include <string.h>

#define  MAXLEN    1000    /* dopuszczalna dugo wiersza */
#define  MAXSTOR   5000    /* wielko dostpnej pamici */

int getline(char *, int);

/* readlines: odczytuje wiersze wejciowe */
int readlines(char *lineptr[], char *linestor, int maxlines)
{
    int len, nlines;
    char line[MAXLEN];
    char *p = linestor;
    char *linestop = linestor + MAXSTOR;

    nlines = 0;
    while ((len = getline(line, MAXLEN)) > 0)
        if (nlines >= maxlines || p+len > linestop)
            return -1;
        else {
            line[len-1] = '\0';      /* usu znak nowego wiersza */
            strcpy(p, line);
            lineptr[nlines++] = p;
            p += len;
        }
    return nlines;
}
