#include  <stdio.h>
#include  <string.h>
#include  <math.h>    /* dla atof() */

#define   MAXOP  100   /* dopuszczalny rozmiar operandu lub operatora */
#define   NUMBER '0'   /* sygna, e pobrano liczb */
#define   NAME   'n'   /* sygna, e pobrano nazw */

int getop(char []);
void push(double);
double pop(void);
void mathfnc(char []);

/* kalkulator z odwrotn notacj polsk */
main()
{
    int type;
    double op2;
    char s[MAXOP];
    
    while ((type = getop(s)) != EOF) {
        switch (type) {
        case NUMBER:
            push(atof(s));
            break;
        case NAME:
            mathfnc(s);
            break;
        case '+':
            push(pop() + pop());
            break;
        case '*':
            push(pop() * pop());
            break;
        case '-':
            op2 = pop();
            push(pop() - op2);
            break;
        case '/':
            op2 = pop();
            if (op2 != 0.0)
                push(pop() / op2);
            else
                printf("error: zero divisor\n");
            break;
        case '\n':
            printf("\t%.8g\n", pop());
            break;
        default:
            printf("error: unknown command %s\n", s);
            break;
        }
    }
    return 0;
}

/* mathfnc: sprawdza, czy cig s jest nazw obsugiwanej funkcji matematycznej */
void mathfnc(char s[])
{
    double op2;

    if (strcmp(s, "sin") == 0)
        push(sin(pop()));
    else if (strcmp(s, "cos") == 0)
        push(cos(pop()));
    else if (strcmp(s, "exp") == 0)
        push(exp(pop()));
    else if (strcmp(s, "pow") == 0)
        op2 = pop();
        push(pow(pop(), op2));
    } else
        printf("error: %s not supported\n", s);
}
