#include <stdio.h>

int brace, brack, paren;

void in_quote(int c);
void in_comment(void);
void search(int c);

/* prosty program sprawdzajcy skadni programu C */
main()
{
    int c;
    extern int brace, brack, paren;

    while ((c = getchar()) != EOF) {
        if (c == '/') {
            if ((c = getchar()) == '*' )
                in_comment();           /* wewntrz komentarza */
            else
                search(c);
        } else if (c == '\'' || c == '"')
            in_quote(c);                /* wewntrz cudzysowu */
        else
            search(c);

        if (brace < 0) {                /* wypisywanie informacji o bdach */
            printf("Unbalanced braces\n");
            brace = 0;
        } else if (brack < 0) {
            printf("Unbalanced brackets\n");
            brack = 0;
        } else if (paren <0) {
            printf("Unbalanced parentheses\n");
            paren = 0;
        }
    }
    if (brace > 0)                      /* wypisywanie informacji o bdach */
        printf("Unbalanced braces\n");
    if (brack > 0) 
        printf("Unbalanced brackets\n");
    if (paren >0) 
        printf("Unbalanced parentheses\n");
}

/* search: wyszukuje podstawowe bdy skadniowe */
void search(int c)
{
    extern int brace, brack, paren;

    if (c == '{')
        ++brace;
    else if (c == '}')
        --brace;
    else if (c == '[')
        ++brack;
    else if (c == ']')
        --brack;
    else if (c == '(')
        ++paren;
    else if (c == ')')
        --paren;
}

/* in_comment: wewntrz komentarza */
void in_comment(void)
{
    int c, d;

    c = getchar();                   /* poprzedni znak */
    d = getchar();                   /* biecy znak */
    while (c != '*' || d != '/') {   /* szukaj koca */
        c = d;
        d = getchar();
    }
}

/* in_quote: wewntrz cudzysowu */
void in_quote(int c)
{
    int d;

    while ((d = getchar()) != c)     /* szukaj koca cudzysowu */
        if (d == '\\')
            getchar();               /* ignoruj sekwencje sterujce */
}
