#include <stdio.h>

#define MAXHIST 15            /* dopuszczalna dugo histogramu */
#define MAXWORD 11            /* dopuszczalna dugo sowa */
#define IN      1             /* wewntrz sowa */
#define OUT     0             /* poza sowem */

/* wywietlanie histogramu pionowego */
main()
{
    int c, i, nc, state;
    int maxvalue;             /* najwiksza warto w wl[] */
    int ovflow;               /* liczba zbyt dugich sw */
    int wl[MAXWORD];          /* liczniki sw o okrelonych dugociach */

    state = OUT;
    nc = 0;                   /* liczba znakw sowa */
    ovflow = 0;               /* liczba sw >= MAXWORD */
    for (i = 0; i < MAXWORD; ++i)
        wl[i] = 0;
    while ((c = getchar()) != EOF) {
        if (c == ' ' || c == '\n' || c == '\t') {
            state = OUT;
            if (nc > 0)
                if (nc < MAXWORD)
                    ++wl[nc];
                else
                    ++ovflow;
            nc = 0;
        } else if (state == OUT) {
            state = IN;
            nc = 1;           /* pocztek nowego sowa */
        } else
            ++nc;             /* wewntrz sowa */
    }
    maxvalue = 0;
    for (i = 1; i < MAXWORD; ++i)
        if (wl[i] > maxvalue)
            maxvalue = wl[i];

    for (i = 1; i < MAXWORD; ++i) {
        for (j = 1; j < MAXWORD; ++j)
            if (wl[j] * MAXHIST / maxvalue) >= i)
                printf(" * ");
            else
                printf("   ");
        putchar('\n');
    }
    for (i = 1; i < MAXWORD; ++i)
        printf("%4d ", i);
    putchar('\n');
    for (i = 1; i < MAXWORD; ++i)
        printf("%4d ", wl[i]);
    putchar('\n');
    if (ovflow > 0)
        printf("There are %d words >= %d\n", ovflow, MAXWORD);
}
