﻿using AbilityScore;

AbilityScoreCalculator calculator = new AbilityScoreCalculator();
while (true)
{
    calculator.RollResult = ReadInt(calculator.RollResult, "Początkowy rzut 4d6");
    calculator.DivideBy = ReadDouble(calculator.DivideBy, "Dzielone przez");
    calculator.AddAmount = ReadInt(calculator.AddAmount, "Dodawana wartość");
    calculator.Minimum = ReadInt(calculator.Minimum, "Minimum");
    calculator.CalculateAbilityScore();
    Console.WriteLine("Obliczone punkty umiejętności: " + calculator.Score);
    Console.WriteLine("Wciśnij Q, by zakończyć, lub inny klawisz, aby kontynuować");
    char keyChar = Console.ReadKey(true).KeyChar;
    if ((keyChar == 'Q') || (keyChar == 'q')) return;
}

static int ReadInt(int defaultValue, string prompt)
{
    Console.Write(prompt + " [" + defaultValue + "]: ");
    string? line = Console.ReadLine();
    if (int.TryParse(line, out int value))
    {
        Console.WriteLine("   użycie wartości " + value);
        return value;
    }
    else
    {
        Console.WriteLine("   użycie wartości domyślnej " + defaultValue);
        return defaultValue;
    }
}

static double ReadDouble(double defaultValue, string prompt)
{
    Console.Write(prompt + " [" + defaultValue + "]: ");
    string? line = Console.ReadLine();
    if (double.TryParse(line, out double value))
    {
        Console.WriteLine("   użycie wartości " + value);
        return value;
    }
    else
    {
        Console.WriteLine("   użycie wartości domyślnej " + defaultValue);
        return defaultValue;
    }
}