﻿namespace BeehiveManagementSystem;

static class Constants
{
    /// <summary>
    /// Początkowa ilość miodu w ulu.
    /// </summary>
    public const decimal INITIAL_HONEY = 25m;

    /// <summary>
    /// Początkowa ilość nektaru w ulu.
    /// </summary>
    public const decimal INITIAL_NECTAR = 100m;

    /// <summary>
    /// Ilość miodu zużywana przez królową w czasie każdej zmiany.
    /// </summary>
    public const decimal QUEEN_COST_PER_SHIFT = 2.15m;

    /// <summary>
    /// Liczba jaj składanych przez królową w trakcie każdej zmiany.
    /// </summary>
    public const decimal EGGS_PER_SHIFT = 0.45m;

    /// <summary>
    /// Jeśli ilość miodu spadnie poniżej tego poziomu, w raporcie na temat zmiany wyświetlane jest ostrzeżenie.
    /// </summary>
    public const decimal LOW_LEVEL_WARNING = 10m;

    /// <summary>
    /// Ilość miodu zużywana przez każdą robotnicę bez przydzielonej funkcji.
    /// </summary>
    public const decimal HONEY_PER_UNASSIGNED_WORKER = 0.5m;

    /// <summary>
    /// Ilość miodu zużywana przez zbieraczkę nektaru w czasie każdej zmiany.
    /// </summary>
    public const decimal NECTAR_COLLECTOR_COST = 1.95m;

    /// <summary>
    /// Ilość nektaru dostarczana przez zbieraczkę nektaru podczas jednej zmiany.
    /// </summary>
    public const decimal NECTAR_COLLECTED_PER_SHIFT = 33.25m;

    /// <summary>
    /// Ilość miodu zużywana przez producentkę miodu w trakcie każdej zmiany.
    /// </summary>
    public const decimal HONEY_MANUFACTURER_COST = 1.7m;

    /// <summary>
    /// Ilość nektaru przetwarzana przez producentkę miodu podczas jednej zmiany.
    /// </summary>
    public const decimal NECTAR_PROCESSED_PER_SHIFT = 33.15m;

    /// <summary>
    /// Ilość jednostek miodu powstająca z jednej jednostki nektaru.
    /// </summary>
    public const decimal NECTAR_CONVERSION_RATIO = .19m;

    /// <summary>
    /// Ilość miodu zużywana przez opiekunkę jaj podczas każdej zmiany.
    /// </summary>
    public const decimal EGG_CARE_COST = 1.35m;

    /// <summary>
    /// Liczba jaj przekształcanych w robotnice bez przydzielonej funkcji w trakcie każdej zmiany.
    /// </summary>
    public const decimal CARE_PROGRESS_PER_SHIFT = 0.15m;
}