﻿using System.Reflection;

HasASecret keeper = new HasASecret();

// Umieszczenie tej instrukcji Console.WriteLine poza komentarzem
// spowoduje błąd kompilacji:
// Element 'HasASecret.secret' jest niedostępny z powodu swojego poziomu ochrony.
// Console.WriteLine(keeper.secret);

// Możesz jednak użyć refleksji, aby uzyskać wartość pola secret.
FieldInfo[] fields = keeper.GetType().GetFields(
                BindingFlags.NonPublic | BindingFlags.Instance);

// Ta pętla foreach spowoduje wyświetlenie "xyzzy" w oknie konsoli.
foreach (FieldInfo field in fields)
{
    Console.WriteLine(field.GetValue(keeper));
}