﻿using System;

namespace SerializeGuys
{
    using System.Collections.Generic;
    using System.Text.Json;

    class Program
    {
        static void Main(string[] args)
        {
            var guys = new List<Guy>() {
               new Guy() { Name = "Borys", Clothes = new Outfit() { Top = "t-shirt", Bottom = "dżinsy" },
                  Hair = new HairStyle() { Color = HairColor.czerwone, Length = 3.5f }
               },
               new Guy() { Name = "Jonasz", Clothes = new Outfit() { Top = "polo", Bottom = "spodnie" },
                  Hair = new HairStyle() { Color = HairColor.szare, Length = 2.7f }
               },
            };

            var jsonString = JsonSerializer.Serialize(guys);
            Console.WriteLine(jsonString);

            var copyOfGuys = JsonSerializer.Deserialize<List<Guy>>(jsonString);
            foreach (var guy in copyOfGuys)
                Console.WriteLine("Wykonałem deserializację tego faceta: {0}", guy);

            var dudes = JsonSerializer.Deserialize<Stack<Dude>>(jsonString);
            while (dudes.Count > 0)
            {
                var dude = dudes.Pop();
                Console.WriteLine($"Następny gość: {dude.Name} ma {dude.Hair}.");
            }

        }
    }
}
