﻿using System;

namespace UseStreamWriterToReadAFile
{
    using System.IO;

    class Program
    {
        static void Main(string[] args)
        {
            var folder = Environment.GetFolderPath(Environment.SpecialFolder.Personal);

            var reader = new StreamReader($"{folder}{Path.DirectorySeparatorChar}tajny_plan.txt");
            var writer = new StreamWriter($"{folder}{Path.DirectorySeparatorChar}emailToCaptainA.txt");

            writer.WriteLine("Do: KapitanWspaniały@obiektowo.net");
            writer.WriteLine("Od: Komendant@obiektowo.net");
            writer.WriteLine("Temat: Czy nas uratujesz - ponownie?");
            writer.WriteLine();
            writer.WriteLine("Odkryliśmy przerażający plan Kanciarza:");

            while (!reader.EndOfStream)
            {
                var lineFromThePlan = reader.ReadLine();
                writer.WriteLine($"Plan -> {lineFromThePlan}");
            }
            writer.WriteLine();
            writer.WriteLine("Pomożesz nam?");

            writer.Close();
            reader.Close();
        }
    }
}
