﻿using System;
using System.ComponentModel;
using System.Threading.Tasks;

namespace Chapter05
{
    [Description("Listing 5.5")]
    class LazyArgumentValidation
    {
        static void Main()
        {
            MainAsync().GetAwaiter().GetResult();
        }

        static async Task MainAsync()
        {
            Task<int> task = ComputeLengthAsync(null); 
            Console.WriteLine("Pobrano zadanie");
            int length = await task;
            Console.WriteLine("Długość: {0}", length);
        }

        static async Task<int> ComputeLengthAsync(string text)
        {
            if (text == null)
            {
                throw new ArgumentNullException("tekst");
            }
            await Task.Delay(500);
            return text.Length;
        }
    }
}
