﻿using System;
using System.ComponentModel;
using static System.Math;

namespace Chapter15
{
    [Description("Listing 15.12")]
    class PropertyPatterns2
    {
        static void Main()
        {
            Greet(new Customer { Address = new Address { Country = "Wielka Brytania" } });
            Greet(new Customer { Address = new Address { Country = "USA" } });
            Greet(new Customer { Address = new Address { Country = "Francja" } });
            Greet(new Customer { Address = new Address() });
            Greet(new Customer());
            Greet(null);
        }

        static void Greet(Customer customer)
        {
            string greeting = customer switch
            {
                { Address: { Country: "Wielka Brytania" } } => "Witaj, kliencie z Wielkiej Brytanii!",
                { Address: { Country: "USA" } } => "Witaj, kliencie z USA!",
                { Address: { Country: string country } } => $"Witaj, kliencie z {country}!",
                { Address: { } } => "Witaj, kliencie z adresem bez kraju!",
                { } => "Witaj, kliencie o nieznanym adresie!",
                _ => "Witaj, null, mój stary przyjacielu!"
            };
            Console.WriteLine(greeting);
        }
    }
}
