﻿using System;

namespace Chapter13
{
    class ImplicitParameterCopy
    {
        // Bez kopiowania właściwości; parametr jest już kopią wartości z jednostki wywołującej.
        public void PrintYearMonthDay(YearMonthDay input) =>
            Console.WriteLine($"{input.Year} {input.Month} {input.Day}");

        // Niejawne kopiowanie każdej wartości.
        public void PrintYearMonthDay(in YearMonthDay input) =>
            Console.WriteLine($"{input.Year} {input.Month} {input.Day}");

        // Bez kopiowania wartości!
        public void PrintYearMonthDay(in ReadOnlyYearMonthDay input) =>
            Console.WriteLine($"{input.Year} {input.Month} {input.Day}");
    }
}
