﻿using System;
using System.Reflection;

namespace Chapter10
{
    class ExceptionThrowingFilter
    {
        // Ten listing nie jest opisany w książce, ale ilustruje sytuację, w której
        // filtr wyjątku *sam* zgłasza wyjątek.
        // Metoda ThrowingMethod z końca kodu zgłasza wyjątek w bloku try, a
        // filtr używa wywołania e.Message[100], które zgłasza inny wyjątek.
        // 
        // W czasie, gdy powstaje ta książka, działanie kodu zależy od sposobu wywołania metody:
        // - gdy metoda jest wywoływana bezpośrednio lub dynamicznie, filtr zgłaszający wyjątek jest ignorowany;
        // - gdy metoda jest wywoływana z użyciem refleksji, przechwytywany jest pierwotny wyjątek,
        //   jednak filtr na wyższym poziomie otrzymuje wyjątek zgłoszony przez filtr.
        //
        // Jest to błąd w środowisku uruchomieniowym, który w przyszłości zapewne zostanie wyeliminowany.

        static void Main()
        {
            var instance = new ExceptionThrowingFilter();
            Console.WriteLine("Bezpośrednie wywołanie");
            try
            {
                instance.MethodCaller();
            }
            catch (Exception e)
            {
                Console.WriteLine($"Przechwycono: {e.Message}");
            }

            Console.WriteLine();
            Console.WriteLine("Wywołanie z użyciem refleksji");
            try
            {
                typeof(ExceptionThrowingFilter).GetMethod(nameof(MethodCaller)).Invoke(instance, null);
            }
            catch (TargetInvocationException e)
            {
                Console.WriteLine($"Przechwycono: {e.InnerException.Message}");
            }

            Console.WriteLine();
            Console.WriteLine("Wywołanie dynamiczne");
            try
            {
                dynamic d = instance;
                d.MethodCaller();
            }
            catch (Exception e)
            {
                Console.WriteLine($"Przechwycono: {e.Message}");
            }
        }

        public void MethodCaller()
        {
            try
            {
                ThrowingMethod();
            }
            catch (Exception e) when (Log(e))
            {
            }
        }

        static bool Log(Exception e)
        {
            Console.WriteLine($"Przefiltrowane: {e.Message}");
            return false;
        }

        public static void ThrowingMethod()
        {
            try
            {
                throw new Exception("Krótki komunikat");
            }
            catch (Exception e) when (e.Message[100] == 'x')
            {
            }
        }
    }
}
