﻿using System;
using System.Diagnostics.Contracts;

namespace Chapter15
{
    class ImplicitNullReferenceChecking
    {
        static string WontReturnNull()
        {
            Contract.Ensures(Contract.Result<string>() != null);
            return "Gwarantowana wartość różna od null";
        }

        static string MightReturnNull()
        {
            return "Późniejsza implementacja może zwracać null";
        }

        static void Main()
        {
            string literal = "Najwyraźniej nie null";
            string wontBeNull = WontReturnNull();
            string mightBeNull = MightReturnNull();
            Console.WriteLine(literal.Length);
            Console.WriteLine(wontBeNull.Length);
            Console.WriteLine(mightBeNull.Length);
        }
    }
}
