﻿using System;
using System.ComponentModel;
using Microsoft.Office.Interop.Word;

namespace Chapter13
{
    [Description("Listing 13.11")]
    class WordMeanings
    {
        static void ShowInfo(SynonymInfo info)
        {
            Console.WriteLine("{0} - liczba znaczeń {1}",
               info.Word, info.MeaningCount);
        }

        static void Main()
        {
            var app = new Application { Visible = false };

            object pl = WdLanguageID.wdPolish;
            ShowInfo(app.get_SynonymInfo("bolesny", ref pl));

            ShowInfo(app.SynonymInfo["miły", WdLanguageID.wdPolish]);
            
            ShowInfo(app.SynonymInfo[Word: "cechy", LanguageID: ref pl]);

            app.Application.Quit();
        }
    }
}
