﻿using System.Collections.Generic;
using System.ComponentModel;

namespace Chapter01
{
    [Description("Listing 1.3")]
    class Product
    {
        public string Name { get; private set; }
        public decimal Price { get; private set; }

        public Product(string name, decimal price)
        {
            Name = name;
            Price = price;
        }

        Product()
        {
        }

        public static List<Product> GetSampleProducts()
        {
            return new List<Product>
            {
                new Product { Name="Ogniem i mieczem", Price = 9.99m },
                new Product { Name="Potop", Price=14.99m },
                new Product { Name="Krzyżacy", Price=13.99m },
                new Product { Name="Faraon", Price=10.99m}
            };
        }

        public override string ToString()
        {
            return string.Format("{0}: {1}", Name, Price);
        }
    }
}
