﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;

namespace MvcReflectionView
{
    public class RouteConfig
    {
        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

            // Listing 20-41
            routes.MapRoute(
                name: "Assembly",
                url: "Reflection/{assemblyName}/",
                defaults: new { controller = "Reflection", action = "Assembly" });

            routes.MapRoute(
                name: "Type",
                url: "Reflection/{assemblyName}/{typeName}/",
                defaults: new { controller = "Reflection", action = "Type" });

            RouteTable.Routes.AppendTrailingSlash = true;


            // Listing 20-47
            routes.MapRoute(
                name: "Reflection",
                url: "Reflection/",
                defaults: new { controller = "Reflection", action = "Index" });

            routes.MapRoute(
                name: "Default",
                url: "{controller}/{action}/{id}",
                defaults: new
                {
                    controller = "Home",
                    action = "Index",
                    id = UrlParameter.Optional
                }
            );


        }
    }
}