﻿using System;
using System.Net;
using System.Reactive.Linq;
using System.Reactive.Threading.Tasks;
using System.Threading.Tasks;

namespace Adaptation
{
    class Example41
    {
        // Listing 11-41
        public static IObservable<string> GetWebPageAsObservable(Uri pageUrl)
        {
            var web = new WebClient();
            Task<string> getPageTask = web.DownloadStringTaskAsync(pageUrl);
            return getPageTask.ToObservable();
        }

        public static void UseAsyncWrapper()
        {
            Console.WriteLine("Pobieramy stronę");
            string pageContent = GetWebPageAsObservable(new Uri("http://www.interact-sw.co.uk/iangblog/")).SingleAsync().Wait();
            Console.WriteLine("Wielkość strony: " + pageContent.Length);
        }
    }
}
