using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Delegates
{
    class Examples11_12
    {
        // Listing 9-11
        public static void CallMeRightBack(Predicate<int> userCallback)
        {
            bool result = userCallback(42);
            Console.WriteLine(result);
        }

        // Listing 9-12
        public static void TestForMajority(Predicate<int> userCallbacks)
        {
            int trueCount = 0;
            int falseCount = 0;
            foreach (Predicate<int> p in userCallbacks.GetInvocationList())
            {
                bool result = p(42);
                if (result)
                {
                    trueCount += 1;
                }
                else
                {
                    falseCount += 1;
                }
            }
            if (trueCount > falseCount)
            {
                Console.WriteLine("Większość predykatów zwróciła wartość: prawda.");
            }
            else if (falseCount > trueCount)
            {
                Console.WriteLine("Większość predykatów zwróciła wartość: fałsz.");
            }
            else
            {
                Console.WriteLine("Jest remis!");
            }
        }
    }
}
