﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace RaisingExceptions
{
    // Listing 8-11 (zawiera zmiany z listingu 8-12)
    public class DeviceNotReadyException : InvalidOperationException
    {
        public DeviceNotReadyException(DeviceStatus status)
            : this("Urządzenie musi być w stanie gotowości - Ready.", status)
        {
        }

        public DeviceNotReadyException(string message, DeviceStatus status)
            : base(message)
        {
            Status = status;
        }

        public DeviceNotReadyException(string message, DeviceStatus status,
                                       Exception innerException)
            : base(message, innerException)
        {
            Status = status;
        }

        public DeviceStatus Status { get; private set; }

        // Listing 8-12
        public override void GetObjectData(SerializationInfo info,
                                   StreamingContext context)
        {
            base.GetObjectData(info, context);
            info.AddValue("Status", Status);
        }

        public DeviceNotReadyException(SerializationInfo info,
                                       StreamingContext context)
            : base(info, context)
        {
            Status = (DeviceStatus) info.GetValue("Status", typeof(DeviceStatus));
        }

    }

    public enum DeviceStatus
    {
        Disconnected,
        Initializing,
        Failed,
        Ready
    }
}
