﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace BasicExceptions
{
    class Program
    {
        static void Main(string[] args)
        {
            HandleException();
            UseCaughtException();
            HandleMultipleExceptionTypes();
        }

        // Listing 8-2
        static int Divide(int x, int y)
        {
            return x / y;
        }

        static void HandleException()
        {
            // Listing 8-3
            try
            {
                using (StreamReader r = new StreamReader(@"C:\Temp\File.txt"))
                {
                    while (!r.EndOfStream)
                    {
                        Console.WriteLine(r.ReadLine());
                    }
                }
            }
            catch (FileNotFoundException)
            {
                Console.WriteLine("Nie można znaleźć pliku!");
            }
        }

        static void UseCaughtException()
        {
            // Listing 8-4
            try
            {
                using (StreamReader r = new StreamReader(@"C:\Temp\File.txt"))
                {
                    while (!r.EndOfStream)
                    {
                        Console.WriteLine(r.ReadLine());
                    }
                }
            }
            catch (FileNotFoundException x)
            {
                Console.WriteLine("Nie udało się odnaleźć pliku '{0}'", x.FileName);
            }
        }

        static void HandleMultipleExceptionTypes()
        {
            // Listing 8-5
            try
            {
                using (StreamReader r = new StreamReader(@"C:\Temp\File.txt"))
                {
                    while (!r.EndOfStream)
                    {
                        Console.WriteLine(r.ReadLine());
                    }
                }
            }
            catch (FileNotFoundException x)
            {
                Console.WriteLine("Nie udało się odnaleźć pliku '{0}'", x.FileName);
            }
            catch (IOException x)
            {
                Console.WriteLine("Błąd wejścia-wyjścia: '{0}'", x.Message);
            }
        }
    }
}
