﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reactive.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Operators
{
    // Listing 11-28
    class Trade
    {
        public string StockName { get; set; }
        public decimal UnitPrice { get; set; }
        public int Number { get; set; }


        public static IObservable<Trade> TestStream()
        {
            return Observable.Create<Trade>(obs =>
            {
                string[] names = { "MSFT", "GOOGL", "AAPL" };
                var r = new Random(0);
                for (int i = 0; i < 100; ++i)
                {
                    var t = new Trade
                    {
                        StockName = names[r.Next(names.Length)],
                        UnitPrice = r.Next(1, 100),
                        Number = r.Next(10, 1000)
                    };
                    obs.OnNext(t);
                }
                obs.OnCompleted();
                return default(IDisposable);
            });
        }
    }

    class Examples28_30
    {
        public static void SumWithAggregate()
        {
            // Listing 11-29
            IObservable<Trade> trades = Trade.TestStream();

            IObservable<long> tradeVolume = trades.Aggregate(
                0L, (total, trade) => total + trade.Number);
            tradeVolume.Subscribe(Console.WriteLine);
        }

        public static void SumWithScan()
        {
            // Listing 11-30
            IObservable<Trade> trades = Trade.TestStream();

            IObservable<long> tradeVolume = trades.Scan(
                0L, (total, trade) => total + trade.Number);
            tradeVolume.Subscribe(Console.WriteLine);
        }
    }
}
