﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Generics
{
    class Examples14_18
    {
        // Listing 4-14
        public static T GetLast<T>(T[] items)
        {
            return items[items.Length - 1];
        }

        public static void InvokeGenericMethod()
        {
            // Listing 4-15
            int[] values = { 1, 2, 3 };
            int last = GetLast<int>(values);

            Console.WriteLine(last);
        }

        // Listing 4-16
        public static T MakeFake<T>()
            where T : class
        {
            return new Mock<T>().Object;
        }

        // Informacje o pobieraniu Moq można znaleźć w komentarzach do Listingu 4-10. 
        // Poniższy kod pozwala skompilować przykład z listingu 4-16 bez posiadania biblioteki Moq.
        private class Mock<T> where T : class
        {
            public T Object { get; set; }
        }

        public static void InvokeGenericMethodWithInference()
        {
            // Listing 4-17
            int[] values = { 1, 2, 3 };
            int last = GetLast(values);

            Console.WriteLine(last);
        }
        

        // Kod umieszczony w komentarzach gdyż ilustruje coś, co nie jest obsługiwane.
        //// Listing 4-18
        //public static T Add<T>(T x, T y)
        //{
        //    return x + y;  // Tego kodu nie uda się skompilować
        //}
    }
}
