﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
// Listing 14-13
using System.Dynamic;

public class CustomDynamicConversion : DynamicObject
{
    public override bool TryConvert(ConvertBinder binder, out object result)
    {
        if (binder.ReturnType == typeof(int))
        {
            result = binder.Explicit ? 1 : 2;
            return true;
        }
        return base.TryConvert(binder, out result);
    }
}


namespace DynamicDetails
{
    class Examples13_14
    {
        public static void CustomConversion()
        {
            // Listing 14-14
            dynamic o = new CustomDynamicConversion();
            int x = o;
            int y = (int) o;
            Console.WriteLine(x);
            Console.WriteLine(y);
        }
    }
}
