﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Inheritance
{
    // Listing 6-35
    public class BaseWithZeroArgCtor
    {
        public BaseWithZeroArgCtor()
        {
            Console.WriteLine("Konstruktor klasy bazowej.");
        }
    }

    public class DerivedNoDefaultCtor : BaseWithZeroArgCtor
    {
        public DerivedNoDefaultCtor(int i)
        {
            Console.WriteLine("Konstruktor klasy pochodnej.");
        }
    }

    // Listing 6-36
    public class BaseNoDefaultCtor
    {
        public BaseNoDefaultCtor(int i)
        {
            Console.WriteLine("Konstruktor klasy bazowej: " + i);
        }
    }

    public class DerivedCallingBaseCtor : BaseNoDefaultCtor
    {
        public DerivedCallingBaseCtor()
            : base(123)
        {
            Console.WriteLine("Konstruktor klasy pochodnej (domyślny).");
        }

        public DerivedCallingBaseCtor(int i)
            : base(i)
        {
            Console.WriteLine("Konstruktor klasy pochodnej: " + i);
        }
    }

    // Listing 6-37
    public class BaseInit
    {
        protected static int Init(string message)
        {
            Console.WriteLine(message);
            return 1;
        }

        private int b1 = Init("Pole b1 klasy bazowej.");

        public BaseInit()
        {
            Init("Konstruktor klasy bazowej.");
        }

        private int b2 = Init("Pole b2 klasy bazowej.");
    }

    public class DerivedInit : BaseInit
    {
        private int d1 = Init("Pole d1 klasy pochodnej.");

        public DerivedInit()
        {
            Init("Konstruktor klasy pochodnej.");
        }

        private int d2 = Init("Pole d2 klasy pochodnej.");
    }

}
