﻿// Listing 4-5
using System;
using System.Collections.Generic;

public class GenericComparer<T> : IComparer<T>
    where T : IComparable<T>
{
    public int Compare(T x, T y)
    {
        return x.CompareTo(y);
    }
}

class Example5
{
    public static void UseComparer()
    {
        var ci = new GenericComparer<int>();
        Console.WriteLine(ci.Compare(42, 42));
        Console.WriteLine(ci.Compare(42, 99));
        Console.WriteLine(ci.Compare(99, 42));

        var cs = new GenericComparer<string>();
        Console.WriteLine(cs.Compare("abc", "abcd"));
    }
}

// Pozostałe przykłady klasy GenericComparer zostały umieszczone w osobnej przestrzeni nazw,
// aby po usunięciu komentarzy pojawiły się prawidłowe błędy. (W przeciwnym razie kompilator C#
// zgłosiłby błąd konfliktu nazw, a nie pozostałe błędy.)
namespace Others
{
    //// Kod umieszczony w komentarzach gdyż ilustruje błąd
    //// Listing 4-6
    //public class GenericComparer<T> : IComparer<T>
    //{
    //    public int Compare(IComparable<T> x, T y)
    //    {
    //        return x.CompareTo(y);
    //    }
    //}

    //// Kod umieszczony w komentarzach gdyż ilustruje błąd
    //// Listing 4-7
    //public class GenericComparer<T> : IComparer<T>
    //{
    //    public int Compare(T x, T y)
    //    {
    //        return x.CompareTo(y);
    //    }
    //}
}