﻿// Example 19-3
using Windows.Storage;
using Windows.UI.Xaml.Controls;

namespace SimpleApp
{
    public partial class MainPage : Page
    {
        public MainPage()
        {
            InitializeComponent();

            var settings = ApplicationData.Current.LocalSettings;
            object currentUserName;
            if (settings.Values.TryGetValue("UserName", out currentUserName))
            {
                usernameText.Text = (string) currentUserName;
            }

            usernameText.TextChanged += usernameText_TextChanged;
        }

        void usernameText_TextChanged(object sender, TextChangedEventArgs e)
        {
            var settings = ApplicationData.Current.LocalSettings;
            settings.Values["UserName"] = usernameText.Text;
        }
    }
}
