﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace DynamicSilverlight
{
    public partial class App : Application
    {

        public App()
        {
            this.Startup += this.Application_Startup;
            this.Exit += this.Application_Exit;
            this.UnhandledException += this.Application_UnhandledException;

            InitializeComponent();
        }

        private void Application_Startup(object sender, StartupEventArgs e)
        {
            this.RootVisual = new MainPage();
        }

        private void Application_Exit(object sender, EventArgs e)
        {

        }

        private void Application_UnhandledException(object sender, ApplicationUnhandledExceptionEventArgs e)
        {
            // Jeśli ta aplikacja jest uruchamiana poza debugerem to wyjątek należy zgłaszać
            // używając systemu obsługi wyjątków przeglądarki. W przeglądarce IE spowoduje to
            // wyświetlenie na pasku stanu przeglądarki żółtą ikonę z wykrzyknikiem, natomiast 
            // Firefox wyświetli informację o błędzie skryptu.
            if (!System.Diagnostics.Debugger.IsAttached)
            {

                // Uwaga: Ten fragment kodu pozwoli aplikacji działać dalej po zgłoszeniu 
                // wyjątku, który nie został obsłużony. 
                // W aplikacji produkcyjnej należy go zmienić w taki sposób, by informacje o wyjątku
                // zostały wyświetlone na witrynie, a aplikacja zatrzymana.
                e.Handled = true;
                Deployment.Current.Dispatcher.BeginInvoke(delegate { ReportErrorToDOM(e); });
            }
        }

        private void ReportErrorToDOM(ApplicationUnhandledExceptionEventArgs e)
        {
            try
            {
                string errorMsg = e.ExceptionObject.Message + e.ExceptionObject.StackTrace;
                errorMsg = errorMsg.Replace('"', '\'').Replace("\r\n", @"\n");

                System.Windows.Browser.HtmlPage.Window.Eval("throw new Error(\"Unhandled Error in Silverlight Application " + errorMsg + "\");");
            }
            catch (Exception)
            {
            }
        }
    }
}
