﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace Examples5_13
{
    class Examples7_10
    {
        public static void TypeOfOperator()
        {
            // Listing 13-7
            Type stringType = typeof(string);
            Type disposableType = typeof(IDisposable);
        }

        public static void TestCompatibility()
        {
            // Listing 13-8
            Console.WriteLine(typeof(string).IsAssignableFrom(typeof(object)));
            Console.WriteLine(typeof(object).IsAssignableFrom(typeof(string)));

        }

        // Listing 13-9
        public static object CreateAndInvokeMethod(
            string typeName, string member, params object[] args)
        {
            Type t = Type.GetType(typeName);
            object instance = Activator.CreateInstance(t);
            return t.InvokeMember(
              member,
              BindingFlags.Instance | BindingFlags.Public | BindingFlags.InvokeMethod,
              null,
              instance,
              args);
        }

        public static void TypeOfGeneric()
        {
            // Listing 13-10
            Type bound = typeof(List<int>);
            Type unbound = typeof(List<>);
        }
    }
}
