﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Delegates
{
    // Listing 9-7
    public class ThresholdComparer
    {
        public int Threshold { get; set; }

        public bool IsGreaterThan(int value)
        {
            return value > Threshold;
        }

        public Predicate<int> GetIsGreaterThanPredicate()
        {
            return IsGreaterThan;
        }
    }

    class Examples7_10
    {
        public static void CreateDelegates()
        {
            // Listing 9-8
            var zeroThreshold = new ThresholdComparer { Threshold = 0 };
            var tenThreshold = new ThresholdComparer { Threshold = 10 };
            var hundredThreshold = new ThresholdComparer { Threshold = 100 };

            Predicate<int> greaterThanZero = zeroThreshold.IsGreaterThan;
            Predicate<int> greaterThanTen = tenThreshold.IsGreaterThan;
            Predicate<int> greaterThanOneHundred = hundredThreshold.IsGreaterThan;

            // Listing 9-10
            Predicate<int> megaPredicate1 =
                greaterThanZero + greaterThanTen + greaterThanOneHundred;

            Predicate<int> megaPredicate2 = greaterThanZero;
            megaPredicate2 += greaterThanTen;
            megaPredicate2 += greaterThanOneHundred;
        }

        public static void DynamicCreate()
        {
            var zeroThreshold = new ThresholdComparer { Threshold = 0 };

            // Listing 9-9
            var greaterThanZero = (Predicate<int>) Delegate.CreateDelegate(
                typeof(Predicate<int>), zeroThreshold, "IsGreaterThan");
        }
    }
}
