﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;

namespace TextHandling
{
    class Examples8_10
    {
        public static void WritingToFile()
        {
            // Listing 16-8
            using (var fw = new StreamWriter(@"c:\temp\out.txt"))
            {
                fw.WriteLine("Zapis tekstu do pliku");
                fw.WriteLine("Akutalna godzina to {0}", DateTime.Now);
            }
        }

        public static void WrapString()
        {
            // Listing 16-9
            string xmlContent =
                "<message><text>Hello</text><recipient>world</recipient></message>";
            var xmlReader = XmlReader.Create(new StringReader(xmlContent));
            while (xmlReader.Read())
            {
                if (xmlReader.NodeType == XmlNodeType.Text)
                {
                    Console.WriteLine(xmlReader.Value);
                }
            }
        }

        public static void RedirectOutput()
        {
            TextWriter oldOut = Console.Out;

            // Listing 16-10
            var w = new System.IO.StringWriter();
            Console.SetOut(w);

            Console.WriteLine("Testujemy");
            Console.SetOut(oldOut);
            Console.WriteLine(w.ToString());
        }
    }
}
