﻿using System;
using System.IO;
using System.Threading.Tasks;
using Windows.Storage;

class StateStore
{
    public static async Task SaveString(string fileName, string value)
    {
        StorageFolder folder = ApplicationData.Current.LocalFolder;
        StorageFile file = await folder.CreateFileAsync(fileName,
            CreationCollisionOption.ReplaceExisting);
        using (Stream s = await file.OpenStreamForWriteAsync())
        using (var w = new StreamWriter(s))
        {
            w.Write(value);
        }
    }

    public static async Task<string> FetchString(string fileName)
    {
        StorageFolder folder = ApplicationData.Current.LocalFolder;
        StorageFile file = await folder.GetFileAsync(fileName);
        using (Stream s = await file.OpenStreamForReadAsync())
        using (var rdr = new StreamReader(s))
        {
            return rdr.ReadToEnd();
        }
    }
}
