﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace Inheritance
{
    // Listing 6-15
    public class Shape
    {
        public Rect BoundingBox { get; set; }
    }

    public class RoundedRectangle : Shape
    {
        public double CornerRadius { get; set; }
    }

    // Listing 6-16
    public class BoxAreaComparer : IComparer<Shape>
    {
        public int Compare(Shape x, Shape y)
        {
            double xArea = x.BoundingBox.Width * x.BoundingBox.Height;
            double yArea = y.BoundingBox.Width * y.BoundingBox.Height;

            return Math.Sign(xArea - yArea);
        }
    }

    public class CornerSharpnessComparer : IComparer<RoundedRectangle>
    {
        public int Compare(RoundedRectangle x, RoundedRectangle y)
        {
            // Mniejsze wierzchołki są ostrzejsze, a zatem, w przypadku tego
            // porównania, mniejszy promień będzie 'większy', dlatego została
            // zmieniona kolejność odejmowania
            return Math.Sign(y.CornerRadius - x.CornerRadius);
        }
    }

    // To fragment definicji typu z biblioteki klas .NET Framework,
    // dlatego został umieszczony w komentarzu - nie należy go kompilować w kodzie.
    // Listing 6-17
    // public interface IComparer<in T>
}
