using System;

namespace StringManipulation
{
	class Tester
	{
		public void Run()
		{
			string s1 = "Witaj ";
			string s2 = "wiecie";
			string s3 = @"Odwied nasz stron: http://www.LibertyAssociates.com";
			string s4 = s1 + s2;
			string s5 = "wiecie";
			string s6 = string.Copy(s3);

			Console.WriteLine("Dugoci utworzonych acuchw...");
			Console.WriteLine("s1: {0} [{1}]", s1.Length, s1);
			Console.WriteLine("s2: {0} [{1}]", s2.Length, s2);
			Console.WriteLine("s3: {0} [{1}]", s3.Length, s3);
			Console.WriteLine("s4: {0} [{1}]", s4.Length, s4);
			Console.WriteLine("s5: {0} [{1}]", s5.Length, s5);
			Console.WriteLine("s6: {0} [{1}]", s6.Length, s6);

			Console.WriteLine("A to trzeci znak utworzonych acuchw...");
			Console.WriteLine("s1: {0} [{1}]", s1[2], s1);
			Console.WriteLine("s2: {0} [{1}]", s2[2], s2);
			Console.WriteLine("s3: {0} [{1}]", s3[2], s3);
			Console.WriteLine("s4: {0} [{1}]", s4[2], s4);
			Console.WriteLine("s5: {0} [{1}]", s5[2], s5);
			Console.WriteLine("s6: {0} [{1}]", s6[2], s6);

			Console.WriteLine("\nCzy w acuchu znajduje si litera h?");
			Console.WriteLine("s1: {0} [{1}]",
			   s1.ToUpper().IndexOf('H') >= 0 ? "tak" : "nie", s1);
			Console.WriteLine("s2: {0} [{1}]",
			   s2.ToUpper().IndexOf('H') >= 0 ? "tak" : "nie", s2);
			Console.WriteLine("s3: {0} [{1}]",
			   s3.ToUpper().IndexOf('H') >= 0 ? "tak" : "nie", s3);
			Console.WriteLine("s4: {0} [{1}]",
			   s4.ToUpper().IndexOf('H') >= 0 ? "tak" : "nie", s4);
			Console.WriteLine("s5: {0} [{1}]",
			   s5.ToUpper().IndexOf('H') >= 0 ? "tak" : "nie", s5);
			Console.WriteLine("s6: {0} [{1}]",
			   s6.ToUpper().IndexOf('H') >= 0 ? "tak" : "nie", s6);

			Console.WriteLine("\nKtre acuchy s rwne s2 [{0}]?", s2);
			Console.WriteLine("s1: {0} [{1}]",
			   String.Compare(s1, s2) == 0 ? "Takie same!" : "Rne", s1);
			Console.WriteLine("s2: {0} [{1}]",
			   String.Compare(s2, s2) == 0 ? "Takie same!" : "Rne", s2);
			Console.WriteLine("s3: {0} [{1}]",
			   String.Compare(s3, s2) == 0 ? "Takie same!" : "Rne", s3);
			Console.WriteLine("s4: {0} [{1}]",
			   String.Compare(s4, s2) == 0 ? "Takie same!" : "Rne", s4);
			Console.WriteLine("s5: {0} [{1}]",
			   String.Compare(s5, s2) == 0 ? "Takie same!" : "Rne", s5);
			Console.WriteLine("s6: {0} [{1}]",
			   String.Compare(s6, s2) == 0 ? "Takie same!" : "Rne", s6);

			Console.WriteLine(
			   "\nKtre acuchy s rwne s2 [{0}] bez sprawdzania wielkoci liter?", s2);
			Console.WriteLine("s1: {0} [{1}]",
			   String.Compare(s1, s2, true) == 0 ? "Takie same!" : "Rne", s1);
			Console.WriteLine("s2: {0} [{1}]",
			   String.Compare(s2, s2, true) == 0 ? "Takie same!" : "Rne", s2);
			Console.WriteLine("s3: {0} [{1}]",
			   String.Compare(s3, s2, true) == 0 ? "Takie same!" : "Rne", s3);
			Console.WriteLine("s4: {0} [{1}]",
			   String.Compare(s4, s2, true) == 0 ? "Takie same!" : "Rne", s4);
			Console.WriteLine("s5: {0} [{1}]",
			   String.Compare(s5, s2, true) == 0 ? "Takie same!" : "Rne", s5);
			Console.WriteLine("s6: {0} [{1}]",
			   String.Compare(s6, s2, true) == 0 ? "Takie same!" : "Rne", s6);
		}

		static void Main()
		{
			Tester t = new Tester();
			t.Run();
		}
	}
}

