using System;

namespace Exercises
{
	interface IConvertible
	{
		string ConvertToCSharp(string stringToConvert);
		string ConvertToVB2005(string stringToConvert);
	}

	interface ICodeChecker : IConvertible
	{
		bool CheckCodeSyntax(string stringToCheck, string whichLang);
	}

	public class ProgramHelper : ICodeChecker
	{
		public ProgramHelper()
		{
			Console.WriteLine("Tworzenie obiektu ProgramHelper");
		}

		public virtual string ConvertToCSharp(string stringToConvert)
		{
			return "Przeksztacam podany acuch znakw na kod w jzyku C#";
		}

		public virtual string ConvertToVB2005(string stringToConvert)
		{
			return "Przeksztacam podany acuch znakw na kod w jzyku VB 2005";
		}

		public bool CheckCodeSyntax(string stringToCheck, string whichLang)
		{
			switch (whichLang)
			{
				case "CSharp":
					Console.WriteLine(
					   "Sprawdzam skadni jzyka C# w acuchu \"{0}\"", stringToCheck);
					return true;
				case "VB2005":
					Console.WriteLine(
					   "Sprawdzam skadni jzyka VB 2005 w acuchu \"{0}\"",
					   stringToCheck);
					return true;
				default:
					return false;
			}
		}
	} // Koniec ProgramHelper

	class Tester
	{

		static void Main()
		{
			Tester t = new Tester();
			t.Run();
		}

		public void Run()
		{
			// Tworzy obiekt klasy ProgramHelper
			ProgramHelper theProgramHelper = new ProgramHelper();

			// Przeksztaca wiersz kodu w jzyku VB na kod w jzyku C#
			string cSharpString = theProgramHelper.ConvertToCSharp(
			   "Public Sub Read() Implements IStorable.Read " +
			   "Console.WriteLine(\"Implementacja metody Read interfejsu IStorable\")"
			   + "End Sub 'Read");

			Console.WriteLine(cSharpString);
			Console.WriteLine(
			   "Sprawdzam skadni acucha \"{0}\"... Wynik {1}", cSharpString,
			   theProgramHelper.CheckCodeSyntax(cSharpString, "CSharp"));

			// Przeksztacanie zmodyfikowanego wiersza z powrotem na jzyk VB
			string vbString = theProgramHelper.ConvertToCSharp(cSharpString);

			Console.WriteLine(vbString);
			Console.WriteLine(
			   "Sprawdzam skadni acucha \"{0}\"... Wynik {1}", vbString,
			   theProgramHelper.CheckCodeSyntax(vbString, "VB2005"));

		} // Koniec run
	}    // Koniec Tester
}       // Koniec namespace

