using System;

namespace Exercises
{
	interface IConvertible
	{
		string ConvertToCSharp(string stringToConvert);
		string ConvertToVB2005(string stringToConvert);
	}

	public class ProgramHelper : IConvertible
	{
		public ProgramHelper()
		{
			Console.WriteLine("Tworzenie obiektu ProgramHelper");
		}

		public virtual string ConvertToCSharp(string stringToConvert)
		{
			return "Przeksztacam podany acuch znakw na kod w jzyku C#";
		}

		public virtual string ConvertToVB2005(string stringToConvert)
		{
			return "Przeksztacam podany acuch znakw na kod w jzyku VB 2005";
		}

	}  // Koniec ProgramHelper

	class Tester
	{

		static void Main()
		{
			Tester t = new Tester();
			t.Run();
		}

		public void Run()
		{
			// Tworzy obiekt klasy ProgramHelper
			ProgramHelper theProgramHelper = new ProgramHelper();

			// Przeksztaca wiersz kodu w jzyku C# na kod w jzyku VB
			string vbString = (
			   "Public Sub Read() Implements IStorable.Read " +
			   "Console.WriteLine(\"Implementacja metody Read interfejsu IStorable\")"
			   + " End Sub 'Read");
			Console.WriteLine(vbString);

			// Przeksztaca zmieniony wiersz z powrotem na kod w jzyku C#
			string cSharpString = theProgramHelper.ConvertToCSharp(vbString);

			Console.WriteLine(cSharpString);

		} // Koniec run
	}    // Koniec Tester
}       // Koniec namespace

