using System;

namespace Debugging
{

	class Tester
	{
		public void Run()
		{

			int myInt = 42;
			float myFloat = 9.685f;

			System.Console.WriteLine("Przed rozpoczciem: \n warto myInt: {0} " +
									 "\n warto myFloat: {1}", myInt, myFloat);

			// przekazanie wartoci przez referencj
			Multiply(ref myInt, ref myFloat);

			System.Console.WriteLine("Po zakoczeniu: \n warto myInt: {0} " +
									 "\n warto myFloat: {1}", myInt, myFloat);
		}

		private static void Multiply(ref int theInt, ref float theFloat)
		{
			theInt = theInt * 2;
			theFloat = theFloat * 2;

			Divide(ref theInt, ref theFloat);
		}

		private static void Divide(ref int theInt, ref float theFloat)
		{
			theInt = theInt * 3;
			theFloat = theFloat * 3;

			Add(ref theInt, ref theFloat);
		}

		private static void Add(ref int theInt, ref float theFloat)
		{
			theInt = theInt - theInt;
			theFloat = theFloat - theFloat;
		}

		static void Main()
		{
			Tester t = new Tester();
			t.Run();
		}
	}
}
