using System;
using System.Collections.Generic;

abstract public class Animal : IComparable
{
	protected int weight;
	protected string name;
	public Animal(int weight, string name)
	{
		this.weight = weight;
		this.name = name;
	}
	abstract public void Speak();
	abstract public void Move();

	public override string ToString()
	{
		throw new Exception("Brak implementacji danej metody lub operacji.");
	}

	public int CompareTo(Object rhs)
	{
		Animal otherAnimal = rhs as Animal;
		if (otherAnimal != null)
		{
			return this.weight.CompareTo(otherAnimal.weight);
		}
		else
		{
			throw new ApplicationException("Oczekiwane byy obiekty Animal");
		}
	}
}

public class Dog : Animal
{
	private string breed;

	public string Breed
	{
		get { return breed; }
		set { breed = value; }
	}
	public Dog(int weight, string name, string breed)
		:
	   base(weight, name)
	{
		this.breed = breed;
	}

	public override void Speak()
	{ Console.WriteLine("Hau"); }

	public override void Move()
	{ Console.WriteLine("Biegnie, biegnie, biegnie, lini si."); }

	public override string ToString()
	{
		return "Wabi si " + this.name + ", wa " + this.weight +
		   " i jestem rasy " + this.breed + "\n";
	}
}

public class Cat : Animal
{

	public Cat(int weight, string name)
		:
	   base(weight, name)
	{ }

	public override void Speak()
	{ Console.WriteLine("Miau"); }

	public override void Move()
	{ Console.WriteLine("Biegnie, skacze, drzemie."); }

	public override string ToString()
	{
		return "Wabi si " + this.name + ", wa " + this.weight +
		   " kilogramw i potrafi mrucze!\n";
	}

	public void Purr()
	{
		Console.WriteLine("Mrrrrrrrrrrrrrrrrrrrrrr\n");
	}
}

public class Tester
{
	static void Main()
	{
		List<Animal> myAnimals = new List<Animal>();
		myAnimals.Add(new Dog(36, "Milog", "Golden"));
		myAnimals.Add(new Cat(6, "Szekspir"));
		myAnimals.Add(new Cat(5, "Alegra"));
		myAnimals.Add(new Dog(25, "Dingo", "kundel"));
		myAnimals.Add(new Dog(10, "Brandy", "Beagle"));

		foreach (Animal a in myAnimals)
		{
			Console.WriteLine(a);
		}

		Console.WriteLine("\nPo sortowaniu wedug rozmiaru...");
		myAnimals.Sort();
		foreach (Animal a in myAnimals)
		{
			Console.WriteLine(a);
		}
	}
}
