using System;

public class Invoice
{
	private string vendor;
	private double amount;

	public string Vendor
	{
		get
		{
			return vendor;
		}
		set
		{
			vendor = value;
		}
	}

	public double Amount
	{
		get
		{
			return amount;
		}
		set
		{
			amount = value;
		}
	}

	// Konstruktor
	public Invoice(string vendor, double amount)
	{
		this.vendor = vendor;
		this.amount = amount;
	}

	// Przeciony operator + przyjmuje dwie faktury (obiekty Invoice).
	// Jeli dostawcy (vendor) s tacy sami, wartoci faktur (amount) naley doda.
	// Jeli nie, operacje nie powiedzie si, a operator zwraca pust faktur.

	public static Invoice operator +(Invoice lhs, Invoice rhs)
	{
		if (lhs.vendor == rhs.vendor)
		{
			return new Invoice(lhs.vendor, lhs.amount + rhs.amount);
		}
		else
		{
			Console.WriteLine("Rni dostawcy. Operacja nieudana.");
			return new Invoice("", 0);
		}
	}

	public void PrintInvoice()
	{
		Console.WriteLine("Faktura od {0} na kwot {1} zotych.", this.vendor,
						  this.amount);
	}
}

public class Tester
{
	public void Run()
	{
		Invoice firstInvoice = new Invoice("FirmaRodzinna", 345);
		Invoice secondInvoice = new Invoice("FirmaGigant", 56389.53);
		Invoice thirdInvoice = new Invoice("FirmaGigant", 399.65);

		Console.WriteLine("Dodawanie pierwszej i drugiej faktury.");
		Invoice addedInvoice = firstInvoice + secondInvoice;
		addedInvoice.PrintInvoice();

		Console.WriteLine("Dodawanie pierwszej i drugiej faktury.");
		Invoice otherAddedInvoice = secondInvoice + thirdInvoice;
		otherAddedInvoice.PrintInvoice();

	}
	static void Main()
	{
		Tester t = new Tester();
		t.Run();
	}
}

