#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct node {
  char *question;
  struct node *no;
  struct node *yes;
} node;

int yes_no(char *question)
{
  char answer[3];
  printf("%s? (t/n): ", question);
  fgets(answer, 3, stdin);
  return answer[0] == 't';
}

node* create(char *question)
{
  node *n = malloc(sizeof(node));
  n->question = strdup(question);
  n->no = NULL;
  n->yes = NULL;
  return n;
}

void release(node *n)
{
  if (n) {
    if (n->no)
      release(n->no);
    if (n->yes)
      release(n->yes);
    if (n->question)
      free(n->question);
    free(n);
  }
}

int main()
{
  char question[80];
  char suspect[20];
  node *start_node = create("Czy podejrzany ma wsy");
  start_node->no = create("Laura Ziomalson");
  start_node->yes = create("Denis yeczka");

  node *current;
  do {
    current = start_node;
    while (1) {
      if (yes_no(current->question))
      {
        if (current->yes) {
          current = current->yes;
        } else {
          printf("PODEJRZANY ZIDENTYFIKOWANY\n");
          break;
        }
      } else if (current->no) {
        current = current->no;
      } else {

        /* Zapisanie w wle "yes" pseudonimu nowego podejrzanego */
        printf("Kto jest podejrzany? ");
        fgets(suspect, 20, stdin);
        node *yes_node = create(suspect);
        current->yes = yes_node;

        /* Zapisanie w wle "no" kopii tego pytania */
        node *no_node = create(current->question);
        current->no = no_node;

        /* Zastpienie tego pytania nowym */
        printf("Podaj pytanie PRAWDZIWE dla %s, lecz NIEPRAWDZIWE dla %s? ",
            suspect, current->question);
        fgets(question, 80, stdin);
        current->question = strdup(question);

        break;
      }
    }
  } while(yes_no("Uruchom ponownie"));
  release(start_node);
  return 0;
}
